﻿-- Insert log messages for errors validating patient on P2P message send and receive
IF NOT EXISTS (SELECT LogMessageId FROM hips.LogMessage WHERE LogMessageId=190)
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES (190, 'Error validating the patient IHI for a received message.', 'IHIService', 'ValidateReceivingPatient', 
	'2015-01-15 00:00:00.000', 'HIPS', '2015-01-15 00:00:00.000', 'HIPS')

IF NOT EXISTS (SELECT LogMessageId FROM hips.LogMessage WHERE LogMessageId=191)
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES (191, 'Error validating the patient IHI for a message to be sent.', 'IHIService', 'ValidateSendingPatient', 
	'2015-01-15 00:00:00.000', 'HIPS', '2015-01-15 00:00:00.000', 'HIPS')
GO
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalByPatientMasterIdAndHpioGet]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HospitalByPatientMasterIdAndHpioGet] 
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Create date:   22 July 2014
-- Description:   Get all hospitals using PatientMasterId and HPIO
-- Modified:      9 February 2016 - Return all properties expected for a Hospital object
-- =============================================
CREATE PROCEDURE [hips].[HospitalByPatientMasterIdAndHpioGet] 
(
	@PatientMasterId INT = null,
	@HPIO VARCHAR(20) = null
)
AS
BEGIN
	-- Get all hospitals using PatientMasterId and HPIO
	SELECT
		h.HospitalId,		
		h.Description,
		h.Name,
		hpo.Name AS HpioName,
		hpo.HpiO AS HpiO,
		hpo.HiCertSerial AS HiCertSerial,
		hpo.PcehrCertSerial AS PcehrCertSerial,
		hpo.VisitorHospitalId AS VisitorHospitalId,
		hpo.[HpoCertSerial],
		hpo.[HiCsp],
		hpo.[PcehrCsp],
		hpo.[HealthProviderOrganisationNetworkId],
		h.AuthorisedEmployeeName,
		h.AuthorisedEmployeeUserId,
		h.Logo,
		h.HealthProviderOrganisationId,
		h.UploadDocumentMinimumAge,
		h.DateCreated,
		h.UserCreated,
		h.DateModified,
		h.UserModified
	FROM hips.HospitalPatient hp
	INNER JOIN hips.Hospital h
		ON hp.HospitalId = h.HospitalId
	INNER JOIN hips.HealthProviderOrganisation hpo
		ON h.HealthProviderOrganisationId = hpo.HealthProviderOrganisationId
	WHERE
		(hp.PatientMasterId = @PatientMasterId)
		AND (hpo.HpiO = @HPIO)
	
END

GO
GRANT EXEC ON [hips].[HospitalByPatientMasterIdAndHpioGet] TO RunStoredProcedure
GO